function	val = vb_read_inifile_keyword(fname,key)
% read keyword value from INI file 
%  val = vb_read_inifile_keyword(fname,key)
% --- Input
% key  : key word
% fname   : file name
% --- Output
% val : keyword value (string)
% if val is numeric, str2num should be appried to val
%
% Masa-aki Sato 2009-07-15
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% K = STRFIND(TEXT,PATTERN) ϡʸ TEXT ǡʸ PATTERN и
%  ǽΥǥåϤޤ

val = [];

fid = fopen(fname,'rt');	% text mode all platforms

if(fid < 0),
  error(['Unable to open file ' fname])
end

% find line with keyword
if isempty(key), return; end;

key = [key '='];

while 1
    next_line = fgetl(fid);
    if ~ischar(next_line), return; end;
    
    result = strfind(next_line,key);
	if ~isempty(result), break, end;
end

val = sscanf(next_line(result+length(key):end),'%s');

fclose(fid);

