function	[xxD] = vb_next_vertex_distance(F,V)
% distance between next neighbor
%   D = vb_next_vertex_distance(F,V)
%
% D : distance between next neighbor [Npatch*3 x 1]
%
% 2007-12-22 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Npatch = size(F,1);  		% number of patch
xxD    = zeros(Npatch,3);

% ̤˴ؤ롼
for j=1:Npatch,
    % ̤ĺǥå
    jx = F(j,:); 
    Vn = V(jx,:);

	% Distance 
	d1 = sum((Vn(1,:) - Vn(2,:)).^2);
	d2 = sum((Vn(2,:) - Vn(3,:)).^2);
	d3 = sum((Vn(3,:) - Vn(1,:)).^2);
	
	xxD(j,:) = sqrt([d1, d2, d3]);
end

xxD = xxD(:);
