function	new_file = vb_join_cell_file_name(filename)
% make new name of new headfile
% [USAGE]
%    new_file = vb_join_cell_file_name(filename);
% [IN]
%    filename :  filename list {1xN}, {Nx1}
% [OUT]
%    new_file : joined filename.
%
% example:
%    filename = {'/home/test/test.eeg.mat', ...
%                '/abc/test2.hdr', ...
%                './abc3021.mat'};
%    new_file :
%       '/home/test/test_test2_abc3021'
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
if ~iscell(filename)
    new_file = filename;
    return;
end

for nf = 1:length(filename)
	fname_body = vb_util_get_file_body(filename{nf});
	if nf==1
		new_file = [fname_body];
	else
		new_file = [new_file '_' fname_body];
	end
end

[fdir,fbody] = vb_get_file_parts(filename{1});

if ~isempty(fdir)
	new_file = [fdir '/' new_file ];
end
