function [verbose_level,verbose_str] = vb_get_verbose
% Get verbose level from VBMEG environment (global) variable 'vbmeg_inst'.
%
% [syntax]
% [verbose_level,verbose_str] = vb_get_verbose
%
% [input]
%
% [output]
% verbose_level: <<int>> Verbose level value. Larger value supresses
%                more messages. 
% verbose_str  : <<string>> Verbose level string. 
%  'NONE'      Suppressing all messages 
%  'EMERGENCY'
%  'WARNING'
%  'NOTICE'    VBMEG default value
%  'INFO'
%  'DEBUG'     Displaying all messages
%
% [example]
% >> vb_set_verbose('WARNING');
%
% [note]
% If 'vbmeg_inst' does not exist, this function will ask if you want to
% terminate program or set some value to 'vbmeg_inst'.  
%
% [history]
% 2010-12-07 Taku Yoshioka
%
% [see also]
% vb_set_verbose, vb_disp
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst;
const = vb_define_verbose;

if ~isfield(vbmeg_inst,'verbose_level')
  disp(['Input verbose level (following value) ' ...
        'or terminate program: ']);
  disp('NONE               (0)'); 
  disp('EMERGENCY          (1)');
  disp('WARNING            (2)');
  disp('NOTICE             (3)');
  disp('INFO               (5)');
  disp('DEBUG             (10)');
  disp('terminate program (-1)');
  
  v = str2num(input('? ','s'));
  
  if v==-1
    error('Terminate');
  else
    vbmeg_inst.verbose_level = v;
  end
end

verbose_level = vbmeg_inst.verbose_level;

switch verbose_level
 case const.VERBOSE_LEVEL_NONE
  verbose_str = 'NONE';
 case const.VERBOSE_LEVEL_EMERGENCY
  verbose_str = 'EMERGENCY';
 case const.VERBOSE_LEVEL_WARNING
  verbose_str = 'WARNING';
 case const.VERBOSE_LEVEL_NOTICE
  verbose_str = 'NOTICE';
 case const.VERBOSE_LEVEL_INFO
  verbose_str = 'INFO';
 case const.VERBOSE_LEVEL_DEBUG
  verbose_str = 'DEBUG';
end

return;
