function	[pathname ,filename] = vb_get_ext_filename(datadir,ext)
% Get file names for specified directory and extension
% --- Usage
%  pathname = vb_get_ext_filename(datadir,ext)
% --- Input
% datadir : data directory name
%    ex.    'D:/data/eeg'
% ext : file extension
%    ex.    '_epoch.eeg.mat'
% --- Output
% pathname : pathname with specified extension
%   if there are multiple files, pathname becomes cell array
%   if there is no file, pathname is empty
%
% Masa-aki Sato 2008-08-14
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

dlist = dir([datadir '/*' ext]);
Nfile = length(dlist);

if Nfile==1,
	filename = dlist(1).name;
	pathname = [datadir '/' dlist(1).name];
elseif Nfile > 1,
	filename = cell(1,Nfile);
	pathname = cell(1,Nfile);

	for n=1:Nfile
		filename{n} = dlist(n).name;
		pathname{n} = [datadir '/' dlist(n).name];
	end
else
	filename = [];
	pathname = [];
end
