function vb_axes_add_click_open(h_axes)
% This funciton gives a functionality to open a new figure which contains a 
% specified axes when the axes is clicked. This enables you to check 
% the axes in the new figure. The function is convenient when the 
% plotted axes is very small.
% (e.g. Click one of Thumbnails, then open a new figure to check in detail). 
% [USAGE]
%    vb_axes_add_click_open(h_axes);
% [IN]
%    h_axes: axes handle.
% [OUT]
%    none
% [History]
%   2013-03-28 rhayashi Initial version
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('h_axes', 'var')
    error('h_axes is a required parameter.');
end
if ~isempty(h_axes) && ishandle(h_axes)
    if ~strcmp(get(h_axes, 'Type'), 'axes')
        error('Specified handle is not axes handle.');
    end
end

%
% --- Main Procedure
%
callback = ['parent = get(gcbo, ''Parent'');', ...
            'h_fig = figure;', ...
            'new_axes = copyobj(parent, h_fig);', ...
            'set(new_axes, ''Position'', [0,0,1,1]);', ...
            'set(get(new_axes, ''children''), ''ButtonDownFcn'', '''');', ...
            'clear h_fig new_axes h_line parent'];

children = get(h_axes, 'Children');
set(children, 'ButtonDownFcn', callback);
