function varargout = dir_dialog_callback(varargin)
% Callback functions for dir_dialog
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
if ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK
    try
        if nargout == 0
            feval(varargin{:}) % FEVAL switchyard
        else
            % There are output value.
            [varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
        end
    catch
        disp(lasterr);
    end
end

% --------------------------------------------------------------------
function varargout = txtInfo_Callback(h, eventdata, handles, varargin)
    dir_ = get(handles.txtInfo, 'String');
    err = false;
    if isdir([handles.mypath, filesep, dir_])
        % search selected directory
        dir_ = [handles.mypath, filesep, dir_];
    elseif isdir([pwd, filesep, dir_])
        % search MATLAB current directory
        err = true;
    elseif isdir(dir_)
        % absolute path
    else
        err = true;
    end
    if err
        set(handles.txtInfo, 'String', handles.mypath);
        return;
    else
        % get absolute path
        current_dir = pwd;
        cd(dir_);
        dir_ = pwd;
        cd(current_dir); 
        if strcmp(dir_(length(dir_)), filesep)
            dir_ = dir_(1:length(dir_)-1);
        end
        % set selected directory
        handles.mypath = dir_;
        handles = update_listbox(handles);

        % set drive(Windows)
        if ispc
            ix = strfind(dir_, ':');
            if ~isempty(ix)
                drive = dir_(1:ix);
                drive_list = get(handles.drive_popup, 'String');
                ix_list = strmatch(drive, drive_list);
                if ~isempty(ix_list)
                    set(handles.drive_popup, 'Value', ix_list);
                end
            end
        end
        % save data
        guidata(handles.browser, handles);
    end

% --------------------------------------------------------------------
function varargout = List_Callback(h, eventdata, handles, varargin)

    index_selected = get(handles.List,'Value');
    path_name = handles.file_path{index_selected};
    new_path  = [handles.mypath filesep path_name];

    if strcmp(path_name, '.')
        return;
    elseif strcmp(path_name, '..')
        % get absolute path
        tmp = pwd;
        cd(new_path);
        new_path = pwd;
        cd(tmp);
        if strcmp(new_path(length(new_path)), filesep)
            new_path = new_path(1:length(new_path)-1);
        end
        handles.mypath = new_path;
    elseif IsdirOK(new_path) == true
        % mypath 1level forward
        handles.mypath = new_path;
    else
        % something error occured.
        return;
    end

    set(handles.txtInfo, 'String', handles.mypath);
    handles = update_listbox(handles);

    % save data
    guidata(handles.browser, handles);

% --------------------------------------------------------------------
function varargout = btnApply_Callback(h, eventdata, handles, varargin)
    handles.mypath = get(handles.txtInfo, 'String');
    guidata(handles.browser, handles);
    
    % This causes dropping out of waitfor in init() 
    set(handles.browser, 'Visible', 'off'); 

% --------------------------------------------------------------------
function varargout = btnCancel_Callback(h, eventdata, handles, varargin)
    handles.mypath = [];
    guidata(handles.browser, handles);

    % This causes dropping out of waitfor in init() 
    set(handles.browser, 'Visible', 'off');

% --------------------------------------------------------------------
function varargout = mkdir_button_Callback(hObject, eventdata, handles, varargin)
    dir_name = inputdlg('', 'input directory name');
    if ~isempty(dir_name)
        new_dir = fullfile(char(handles.mypath), char(dir_name));
        mkdir(new_dir);
        handles.mypath = new_dir;
        handles = update_listbox(handles);
        % save data
        guidata(handles.browser, handles);
    end

% --------------------------------------------------------------------
function varargout = drive_popup_Callback(h, eventdata, handles, varargin)

    val = get(handles.drive_popup, 'Value');
    select_list = get(handles.drive_popup, 'String');
    handles.mypath = select_list{val};
    set(handles.txtInfo, 'String', handles.mypath);
    handles = update_listbox(handles);

    % save data
    guidata(handles.browser, handles);

% --------------------------------------------------------------------
function varargout = close_function(h, eventdata, handles, varargin)
    btnCancel_Callback(h, eventdata, handles, varargin);

% --------------------------------------------------------------------
function handles = update_listbox(handles)

    if IsdirOK(handles.mypath) == false
        return;
    end
    
    items   = dir([handles.mypath, filesep]);
    n_items = max(size(items));

    if strcmp(handles.mypath, handles.START_DIR)
        root = true;
    else
        root = false;
    end

    handles.file_path = [];
    k=0;

    % set directory names to file_path{}
    for i = 1 : n_items
        if items(i).isdir
            dir_name = items(i).name;
            if root & (handles.move_mode == false) &...
               (strcmp(dir_name, '.') | strcmp(dir_name, '..'))
                % do not add '.' and '..'
                continue;
            else
                k = k+1;
                handles.file_path{k} = dir_name;
            end
        end
    end

    set(handles.List, 'String', handles.file_path, 'Value', 1);
    set(handles.txtInfo, 'String', handles.mypath);

% --------------------------------------------------------------------
function set_drive_info(handles, current_dir)

    drive_name = drive_search;
    num_drive  = length(drive_name);
    current_drive = 1;

    for k=1:num_drive
        if strncmp( upper(current_dir),...
           drive_name{k}, ...
           length(drive_name{k}) )
           current_drive = k;
           break;
        end
    end
    
    set(handles.drive_popup, 'String', drive_name);
    set(handles.drive_popup, 'Value', current_drive);
 
% --------------------------------------------------------------------
function [drive_name] = drive_search

    if ispc
        % Search drive (from C to Z)
        cnt = 0;
        for drive = [real('C'):real('Z')]
            str = sprintf('%c:', drive);
            if length( dir(str) )
                % drive found
                cnt = cnt+1;
                drive_name{cnt} = str;
            end
        end
    end

% --------------------------------------------------------------------
function [result] = IsdirOK(path_name)
    items   = dir([path_name, filesep]);
    n_items = max(size(items));
    n_dir   = 0;
    result = false;

    try
        for j = 1 : n_items
            if items(j).isdir
                n_dir = n_dir+1;
            end
        end
    catch
        % directory is not accessable.
        result = false;
        return;
    end

    if n_dir < 1
        % directory is probably abnormal.
        result = false;
    elseif n_dir == 2
        % only '.' and '..'
        result = true;
    else
        result = true;
    end

