function shells = vb_load_head_shell(head_file, tags)
% load head shell model from VBMEG head model file(.head.mat)
% [Usage]
%     shells = vb_load_head_shell(head_file[,tags]);
% [Input]
%     head_model : VBMEG head model file(.head.mat)
%           tags : [optional] shell name to load.  [string or cellstr]
%                  case-insensitive. if not specified(or empty) all the shell
%                  data will be loaded.
%                  (e.g. 'CSF', {'CSF', 'Skull', 'Scalp'})
% [Output]
%  shells{n}      : Data get by specified tags.     [Nx1]
%                   shells(n) is loaded by tags{n}. 
%         .Vhead  : Vertices.
%         .Fhead  : Patches.
%         .XXhead : Normal vector.
%         .Tag    : Shell name.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('head_file', 'var')
    error('head_file is a required.');
end
if exist(head_file, 'file') ~= 2
    error('Specified file not found.');
end
if ~exist('tags', 'var')
    tags = [];
end

if ischar(tags)
    tags = {tags};
end
if isempty(tags)
    % tags = []; % means all the tags.
    tmp = vb_load_head_shell_info(head_file);
    tags = tmp.tags;
end

if ~iscellstr(tags)
    error('Specified Invalid tag');
end

%
% --- Previous check
%
Nshell = vb_head_get_layer_num(head_file);
Ntags  = length(tags);

shells  = [];
for k=1:Ntags
    shells = [shells; inner_shell_template]; % allocate 1 struct

    % retrieve data from head_file
    info  = vb_head_get_specified_headinfo(head_file, tags{k});
    if isempty(info)
        error('Specified invalid tag  : %s', tags{k});
    end
    % There is a case that the 1shell model doesn't have LayerTag.
    if Nshell == 1 && ~isfield(info, 'LayerTag')
        info.LayerTag = 'CSF';
    end
    % Set fields
    shells(k).Vhead  = info.Vhead;
    shells(k).Fhead  = info.Fhead;
    shells(k).XXhead = info.XXhead;
    shells(k).Tag    = info.LayerTag;
end

function template = inner_shell_template
template = struct;
template.Vhead  = [];
template.Fhead  = [];
template.XXhead = [];
template.Tag    = [];
