function	[V, xx] = vb_load_cortex_area(brainfile,areafile,area_key, mode, coord_type)
% Load cortical vertex coordinate & normal vector specified by area_key
%  [V, xx] = vb_load_cortex_area(brainfile,areafile,area_key,mode,coord_type)
% -- Input 
% brainfile : Brain file name
% --- Optional input
% areafile  : Area file name
% area_key  : area key
% mode = 0  : normal vector at the vertex
%      = 1  : average normal vector in the neighbor of BV original brain
% coord_type : = 'subj' : subject brain normal. 
%              = 'std'  : standard brain normal(valid in BRAIN-MAT V2 format).
% --- Output
% V   : cortex vertex coordinate [Nvertex, 3]
% xx  : Normal vector to cortical surface [Nvertex, 3]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('mode','var'), mode = 0; end;

if ~exist('coord_type', 'var')
    coord_type = 'subj';
end

if strcmp(coord_type, 'subj')
    [V, tmp, xx] = vb_load_cortex(brainfile, 'subj');
else
    [V, tmp, xx] = vb_load_cortex(brainfile);
end

if mode == 1
	xx = vb_cortex_normal_average(brainfile,areafile,area_key,coord_type);
    return;
end

if ~exist('areafile','var') || ~exist('area_key','var'),
	return;
end

%
% select area
%
if ~isempty(areafile) && ~isempty(area_key)
	Area = vb_get_area([areafile], area_key);
	ix = Area.Iextract;
	V  = V(ix,:);
	xx = xx(ix,:);
end

