function	[B, Vdim, Vsize] = vb_load_analyze_to_left(analyzefile)
% load analyze/nifti image to LAS orientation
%  [B, Vdim, Vsize] = vb_load_analyze_to_left(analyzefile)
% --- Input
% analyzefile - Analyze/Nifti filename 
%               Default Analyze file is left-handed  LAS image
%               Default Nifti   file is Right-handed RAS image
% --- Output
% B     : 3D image data  [Xdim, Ydim, Zdim ]
% Vdim  : image size  [Xdim  Ydim  Zdim ] (voxels)
% Vsize : voxel size  [x y z ] (mm)
%
% written by M. Sato  2008-2-18
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% load analyze/nifti image file to RAS orientation
avw = load_nii_ras(analyzefile);

B = avw.img;

Vdim  = size(B);
Vsize = avw.hdr.dime.pixdim(2:4);

% flip x-axis to LAS
B = B(Vdim(1):-1:1, :,:);

%% written by M. Sato  2005-8-1
%
%if ~isempty( findstr(analyzefile, '.hdr') )
%	analyzefile = analyzefile(1:findstr(analyzefile, '.hdr')-1);
%	analyzefile = [analyzefile '.img'];
%end
%
%% load analyze image file (left-hand)
%try
%  % Faster than avw_img_read, but sometimes make error
%  [B, Vdim, Vsize] = read_image(analyzefile);
%  B = reshape(B,Vdim);
%catch
%  warning(['The "read_image" function output an error. '...
%	   'Try "avw_img_read" function']);
%  avw = avw_img_read(analyzefile);
%  B   = avw.img;
%  [Vdim, Vsize] = spm_hread(analyzefile);
%end
%
%return
%
%%&& DEBUG
%B1   = B1(Vdim(1):-1:1, :,:);
%errB = vb_err_array3d(B,B1)
%errD = Vdim  - Vdim1
%errS = Vsize - Vsize1
%%&& DEBUG
