function vb_add_area(areafile,AreaNew,MRI_ID,flag)
% This function is used to register cortical area data. 
% 
% [syntax]
% vb_add_area(areafile,area_new,MRI_ID,flag)
%
% [input]
% areafile : Cortical area file (.area.mat).
% area_new : Area information struct to be registered. 
% area_new.Iextract: Set of vertex indices of the new data. 
% area_new.key     : ID of the new data. 
% MRI_ID  : <optional> If 'areafile' does not exist, this MRI ID is
%           assigned to the actfile created in this function. If this 
%           variable is not set, MRI_ID will be set to '0000000' as a 
%           tentative identifier. 
% flag    : <optional> = ON  : confirmation dialog will be shown. <default> 
%                      = OFF : confirmation dialog will be suppressed. 
%
%
% [note]
% If cortical area file, specified by 'areafile' parameter, does not
% exist, the file will be created automatically. 
%
% [example]
% >> areafile = './TY/data/TY.area.mat';
% >> Area.key = 'tmp';
% >> Area.Iextract = [1:I]'; % I is the number of vertices
% >> vb_add_area(areafile,Area);
%
% [history]
% 2005-01-07 Taku Yoshioka
% 2010-05-26 Taku Yoshioka
%  Message display changed
% 2015-11-04 rhayashi
%  Re-implement flag option.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% Previous check
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~exist('flag', 'var')
    flag = ON;
end

%
% Verbose level setting
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global vbmeg_inst
verbose_const = vb_define_verbose; 

if isempty(vbmeg_inst) | ~isfield(vbmeg_inst,'verbose_level'), 
  verbose_level = verbose_const.VERBOSE_LEVEL_NOTICE;
else
  verbose_level = vbmeg_inst.verbose_level;
end

%
% If given areafile is exist or not?
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if exist(areafile) == 2
  load(areafile);
  % Old version support
  if ~exist('MRI_ID'), 
    MRI_ID = '0000000';
    vb_disp(['Area file ''' areafile ''' is a old version, ' ...
             'in which variable ''MRI_ID'' is not saved. A tentative ' ...
             'ID ''0000000'' was automatically assigned to the area ' ...
             'file. '],verbose_const.VERBOSE_LEVEL_INFO);
  end
else
  if nargin <= 2, MRI_ID = '0000000'; end;
  vb_disp('New area file was created. ');
  Area = cell(0,1);
end

%
% Identifier duplicatioin check
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
inc_size = 1;
for i = 1:length(Area)
  if strcmp(AreaNew.key,Area{i}.key)
    inc_size = 0;
    if verbose_level>=verbose_const.VERBOSE_LEVEL_NOTICE && flag == ON
      msg = ['Area ID ''' AreaNew.key ''' is already used. ' ...
         'Overwrite ?'];
      str = questdlg(msg,'Area registration','Yes','Cancel', ...
             'Cancel');
      if strcmp(str,'Yes')
        Area{i} = AreaNew;
        h = msgbox(['Area ID ''' AreaNew.key ''' was overwritten.']);
        uiwait(h);
      end
    else
      vb_disp(['Area ID ''' AreaNew.key ''' is used, ' ...
               'so it is overwritten with new data. '], ...
               verbose_const.VERBOSE_LEVEL_WARNING); 
      Area{i} = AreaNew;
    end
  end
end

%
% Add new area information and save the area file
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tmp = cell(length(Area)+inc_size,1);
for i = 1:length(Area)
  tmp{i} = Area{i};
end

if inc_size
  tmp{length(Area)+1} = AreaNew;
  Area = tmp;
end

vb_fsave(areafile,'Area','MRI_ID');
