function vb_add_act(actfile,act_new,MRI_ID,flag)
% This function is used to register cortical activity data. 
% 
% [syntax]
% vb_add_act(actfile,act_new,MRI_ID,flag)
%
% [input]
% actfile : Cortical activity file (.act.mat).
% act_new : Activity information struct to be registered. 
% act_new.xxP     : Activity values of the new data. 
% act_new.key     : ID of the new data. 
% act_new.comment : Comment on the new data. 
% MRI_ID  : <optional> If 'areafile' does not exist, this MRI ID is
%           assigned to the actfile created in this function. If this
%           variable is not set, MRI_ID will be set to '0000000' as a 
%           tentative identifier. 
% flag    : <optional> = ON  : confirmation dialog will be shown. <default> 
%                      = OFF : confirmation dialog will be suppressed. 
%
% [note]
% If cortical activity file, specified by 'actfile' parameter, does not
% exist, the file will be created automatically. 
%
% [example]
% >> actfile = './TY/data/TY.act.mat';
% >> act.key = 'tmp';
% >> act.xxP = ones(I,1); % I is assumed to be the number of vertices
% >> act.comment = 'test data';
% >> vb_add_act(actfile,act);
%
% [history]
% 2005-01-07 Taku Yoshioka
% 2010-05-26 Taku Yoshioka
%  Message display changed
% 2015-11-04 rhayashi
%  Re-implement flag option.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% Previous check
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~exist('flag', 'var')
    flag = ON;
end

%
% Verbose level setting
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global vbmeg_inst
verbose_const = vb_define_verbose; 

if isempty(vbmeg_inst) | ~isfield(vbmeg_inst,'verbose_level'), 
  verbose_level = verbose_const.VERBOSE_LEVEL_NOTICE;
else
  verbose_level = vbmeg_inst.verbose_level;
end

%
% If given areafile is exist or not?
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if exist(actfile) == 2
  load(actfile);
  % Old version support
  if ~exist('MRI_ID'), 
    MRI_ID = '0000000';
    vb_disp(['Activity map file ' actfile ' is a old version, ' ...
             'in which variable ''MRI_ID'' is not saved. A tentative ' ...
             'ID ''0000000'' was automatically assigned to the area ' ...
             'file. '],verbose_const.VERBOSE_LEVEL_INFO);
  end
else
  if nargin <= 2, MRI_ID = '0000000'; end;
  vb_disp('New activity map file was created. ');
  Act = cell(0,1);
end

%
% Identifier duplicatioin check
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
inc_size = 1;
for i = 1:length(Act)
  if strcmp(act_new.key,Act{i}.key)
    inc_size = 0;
    if verbose_level>=verbose_const.VERBOSE_LEVEL_NOTICE && flag == ON
      msg = ['Activity map ID ''' act_new.key ''' is already used. ' ...
         'Overwrite ?'];
      str = questdlg(msg,'Activity map registration','Yes', ...
             'Cancel','Cancel');
      if strcmp(str,'Yes')
        Act{i} = act_new;
        h = msgbox(['Activity map ID ''' act_new.key ...
                ''' was overwritten.']);
        uiwait(h);
      end
    else
      vb_disp(['Activity map ID ''' act_new.key ''' is used, ' ...
               'so it is overwritten with new data. '], ...
              verbose_const.VERBOSE_LEVEL_WARNING); 
      Act{i} = act_new;
    end
  end
end

%
% Add new activity map and save the activity map file
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tmp = cell(length(Act)+inc_size,1);
for i = 1:length(Act)
  tmp{i} = Act{i};
end

if inc_size
  tmp{length(Act)+1} = act_new;
  Act = tmp;
end

vb_fsave(actfile,'Act','MRI_ID');
