function	xxn = vb_vertex_normal(V,F,xxf)
% normal vector assigned for vertex
%  xxn = vb_vertex_normal(V,F,xxf)
%
% --- Input
% V : vertex of surface
% F : triangle patch index
% xxf  : normal vector of triangle
% --- Output
% xxn  : normal vector assigned for vertex
%
% Ver 1.0  by M. Sato  2004-2-10
%
% ̤ˡĺˡ׻
%  V(n, 1:3)  : ĺΰ
%  F(j, 1:3)  : ̣ĺΥǥå
% xxf : ̤ˡ٥ȥ
% xxn : ĺˡ = ĺܤ뻰ˡʿ
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Npoint = size(V,1);  	% ĺ
Npatch = size(F,1);

% ĺˡ = ĺܤ뻰ˡʿ
xxn   = zeros(Npoint,3);	

for n=1:Npatch,
    % ̣ĺǥå
	j1=F(n,1);
	j2=F(n,2);
	j3=F(n,3);
    
    xxn(j1,:) = xxn(j1,:) + xxf(n,:);
    xxn(j2,:) = xxn(j2,:) + xxf(n,:);
    xxn(j3,:) = xxn(j3,:) + xxf(n,:);
end;

% ˡ
xxs = sqrt(sum(xxn.^2,2));
xxs = max(xxs,eps);
xxn = xxn./xxs(:,ones(1,3));
