function	[JDall, JDpoint] = vb_neighbor_cos(xxF,xx,Iextract)
% Calculate direction COS between cortex normal vector and
%                                 that of neighbor points
% xx(i,:)      : ʬǾǥĺ i ˡ
% Iextract(i)  : ʬǾǥĺ i  Ǿǥĺֹ
% xxF{n}       : Ǿǥĺ n  ܶ˵ĺֹ
%
% JDall(i)	   : Direction COS between point-i and its neighbor point
% JDpoint(i,1) : Current  point inex
% JDpoint(i,2) : Neighbor inex
%
% Ver 1.0 written by M. Sato  2003-3-15
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

NV		= size(xxF,1);					% Number of vertex

if nargin < 3, Iextract = 1:NV; end;

% ĺֹ椫鿷ĺֹѴѴɽ
% Itrans(i)=0 : ĺֹ = i Ͽĺ˴ޤޤʤ
% Itrans(i)=j : ĺֹ = i Ͽĺ = j б
N				 = length(Iextract);
Itrans			 = zeros(NV,1);
Itrans(Iextract) = 1:N;

JDpoint = [];

for i=1:N,
	n		= Iextract(i);
	indx	= Itrans(xxF{n});				% Neighbor index
	inext	= indx(indx>0);
	NL		= length(inext);
	
	if NL==0, continue; end;
	
	JDpoint = [ JDpoint; i*ones(NL,1) ,inext(:) ];
end;

J0		= xx(JDpoint(:,2),:);	% Current direction at n
JJ		= xx(JDpoint(:,1),:);	% Current direction at neighbor
JDall	= sum( JJ.*J0 , 2 );	% Direction COS
