function vb_inflate_to_flat(parm)
% Inflation model -> flat model
%
% Ver 1.0 written by M. Sato  2003-3-15
% Modified by Taku Yoshioka 2003-07-30
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

dir   = parm.dir ;
file  = parm.file;

tic;
fprintf('--- Make Flat model ');

% ĥ '.mat' 
if ~isempty( findstr(file.brain, '.mat') )
	BRAINfile = file.brain(1:findstr(file.brain, '.mat')-1);
else
	BRAINfile = file.brain;
end

load([dir.inflate  file.inflate], 'F','V','inf_C','xxA');

% --- Brain-Voyager coordinate
%
% V0L/R  X:front(0)->back(255), Y:Top(0)->Bottom(255) , Z:left(0)->right(255)

% Define various projection
% X/Y/Z : X/Y/Z-projection direction
% L/R   : Left/Right cortex
% F/B   : Front/Back-projection

% Projection & Left/Right & Front/back specification flag
Pmode.flg = {'XLB';'XLF';'XRB';'XRF'; ...
             'ZLB';'ZLF';'ZRB';'ZRF'; ...
             'YLB';'YLF';'YRB';'YRF'};

% X/Y/Z-projection direction index
% X/Y/Z : 1/2/3
Pmode.XYZ  = [ 1 1 1 1  2 2 2 2  3 3 3 3 ];

% Left/Right & Front/Back index
% 'LB'/'LF'/'RB'/'RF' : 1/2/3/4
Pmode.LRFB = [ 1 2 3 4  1 2 3 4  1 2 3 4 ];

% X-Projection 
Xdim	 = 1;

[XX, IXX, FXX, VXX] = ...
	vb_inflate_to_flat_func(V,F,Xdim);

% Y-Projection 
Xdim	 = 2;

[YY, IYY, FYY, VYY] = ...
	vb_inflate_to_flat_func(V,F,Xdim);

% Z-Projection 
Xdim	 = 3;

[ZZ, IZZ, FZZ, VZZ] = ...
	vb_inflate_to_flat_func(V,F,Xdim);

% XX  : Projected spherical coordinate 
% IXX : Partition index (L/R & U/D) for each vertex
% FXX = { FLU;  FLD;  FRU;  FRD }; % Face index for each part {LU;LD;RU;RD}

% Combine different projection
XYsph = cell(3,1);

% XYZ-coordinate 
XYsph{1}.xyz = XX;	% X-projection
XYsph{2}.xyz = YY;	% Y-projection
XYsph{3}.xyz = ZZ;	% Z-projection

% Projected plane index for each point
XYsph{1}.ID  = IXX;	% X-projection
XYsph{2}.ID  = IYY;	% Y-projection
XYsph{3}.ID  = IZZ;	% Z-projection

% Face index for projected plane
XYsph{1}.FLR = FXX;	% X-projection
XYsph{2}.FLR = FYY;	% Y-projection
XYsph{3}.FLR = FZZ;	% Z-projection

% Projected spherical coordinate 
% XYsph{prj}.xyz : XYZ-coordinate , prj = 1,2,3 : X,Y,Z-projection
% XYsph{prj}.ID  : Projected plane index
% XYsph{prj}.FLR : Face index for projected plane

fprintf('%f[sec]\n',toc);

fprintf(['--- Save inflate and flat models (' file.inflate ')\n']);
vb_fsave([dir.inflate  file.inflate],'F','V','XYsph','Pmode','inf_C', ...
     'xxA');


