function    [Indx ,ddmin, Vref2, Fref2] = ...
    vb_find_no_overlap_divide(Vref,Vnew,Fref,Rmax)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3 ||  isempty(Fref),
    error('Fref is necessary input') ;
end;

fprintf('Ver2 vb_find_no_overlap_divide start\n\n')

% sparse inverse distance matrix between Vref and Vnew
d = vb_sparse_inv_distance(Vref,Vnew, Rmax);

% find overlap vertex in Vref
[overlap0,ddmin0,Indx0] = vb_find_overlap(d);

% max distance of ddmin
dmin0 = max(ddmin0(:));
fprintf('max distance of ddmin at 1st stage = %g\n',dmin0)

if overlap0.Noverlap == 0, 
    ddmin = ddmin0;
    Indx = Indx0;
    Vref2 = Vref;
    Fref2 = Fref;
    fprintf('No overlap at 1st stage\n')
    clear d
    %pack;
    return; 
else
    fprintf('Noverlap at 1st stage = %d , Mean Multiplicity = %g\n', ...
    overlap0.Noverlap, mean(overlap0.Nmulti)), 
end;

Ntry = 20;
overlap = overlap0;

for jj = 1:Ntry
    % add reference vertex by dividing triangle of overlap point 
    [Vadd, Iadd, Vref2, Fref2] = vb_add_patch_vertex(overlap,Vref,Fref);
    
    fprintf('Add reference vertex: %d\n',size(Vadd,1))
    
    dadd = vb_sparse_inv_distance(Vadd,Vnew, Rmax);
    
    dd = [d; dadd];

    % find overlap vertex in Vref with Vadd
    [overlap1,ddmin1,Indx1] = vb_find_overlap(dd);
    
    % max distance of ddmin
    dmin1 = max(ddmin1(:));
    fprintf('max distance of ddmin at %d-th stage = %g\n',jj,dmin1)
    
    if overlap1.Noverlap == 0, 
        ddmin = ddmin1;
        Indx  = Indx1;
        fprintf('No overlap at %d-th stage with added vertex \n',jj)
        clear d dd dadd
        %pack;
        return; 
    else
        fprintf('Noverlap at %d-th stage = %d , Mean Multiplicity = %g\n', ...
        jj, overlap1.Noverlap, mean(overlap1.Nmulti)), 
    end;
    
    %% try to find no overlap mapping
    [dd, overlap2, ddmin2, Indx2, iter] = ...
        vb_find_no_overlap(dd,overlap1,Rmax);
    
    % max distance of ddmin
    dmin2 = max(ddmin2(:));
    fprintf('max distance of ddmin after no overlap try')
    fprintf(' at %d-th stage = %g\n',jj,dmin2)
    
    if overlap2.Noverlap==0,
        ddmin = ddmin2;
        Indx  = Indx2;
    
        fprintf('No overlap at %d-th stage\n',jj)
        
        clear d dd dadd
        %pack;
        return
    else
        fprintf('Noverlap (after iter = %d) = %d at %d-th stage\n',...
        iter, overlap2.Noverlap,jj), 
        
        overlap = overlap2;
        
        if jj < Ntry
            Vref = Vref2;
            Fref = Fref2;
        else
            ddmin = ddmin2;
            Indx  = Indx2;
        end
    end
end

clear d dd dadd
%pack;

