function [Indx ,ddmin] = vb_find_nearest_point_no_overlap(Vref,Vnew,Rmax)

fprintf('Ver2 vb_find_nearest_point_no_overlap start\n\n')

% sparse inverse distance matrix between Vref and Vnew
d = vb_sparse_inv_distance(Vref,Vnew, Rmax);

[overlap0,ddmin0,Indx0] = vb_find_overlap(d);

% max distance of ddmin
dmin0 = max(ddmin0(:));
fprintf('max distance of ddmin at 1st stage = %g\n',dmin0)

if overlap0.Noverlap == 0, 
	ddmin = ddmin0;
	Indx = Indx0;
	fprintf('No overlap at 1st stage\n')
	clear d
	%pack;
	return; 
else
	fprintf('Noverlap at 1st stage = %d , Mean Multiplicity = %g\n', ...
	overlap0.Noverlap, mean(overlap0.Nmulti)), 
end;

[d1, overlap, ddmin, Indx, iter] = vb_find_no_overlap(d,overlap0,Rmax);

% max distance of ddmin
dmin1 = max(ddmin(:));
fprintf('max distance of ddmin at 2nd stage = %g\n',dmin1)

if overlap.Noverlap == 0, 
	fprintf('No overlap at 2nd stage (after iter = %d)\n', iter)
else
	fprintf('Noverlap (after iter = %d) = %d , Mean Multiplicity = %g\n', ...
	iter,overlap.Noverlap, mean(overlap.Nmulti)), 
end;

clear d d1
%pack;

return
