function [t_thresh,p_thresh,thresh_map]=plot_scl_stat(t_out,p_out,scl_frq,scl_time,mn1,mn2,p_crit,thresh_crit);
%[t_thresh,p_thresh,thresh_map]=plot_scl_stat(t_out,p_out,scl_frq,scl_time,mn1,mn2,p_crit,thresh_crit);
%p_crit default = 0.05
%thresh_crit retrict range for which stats shown based on mean energy mn1 mn2 
%   defalt=0  entire scalogram  
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
[sz_frq,sz_time]=size(t_out);

if nargin<3
   scl_frq=1:sz_frq;
end
if nargin<4
   scl_time=1:sz_time;
end
if nargin<5
   skip=1;
end
if nargin<7
   p_crit=.05;
end
if nargin<8
   thresh_crit=0;
end

if thresh_crit==1
   mnb=mean(mn1+mn2,3);
   mnb2=reshape(mnb,sz_frq*sz_time,1);
   tcr=find(mnb2>((-.5*std(mnb2))+mean(mnb2)));
   thresh_map=zeros(sz_frq,sz_time);
   thresh_map(tcr)=ones(size(tcr));
   %zr=zeros(sz_freq,sz_time));
   %zr(:,7:50)=ones(32,44);
   %thresh_map=thresh_map.*zr;
else
   thresh_map=ones(sz_frq,sz_time);
end

x=find(abs(p_out)<p_crit);
t_thresh=zeros(sz_frq,sz_time);
t_thresh(x)=t_out(x);
t_thresh=t_thresh.*thresh_map;
cr1=t_thresh~=0;
p_thresh=p_out.*cr1;


figure
pcolor(scl_time,scl_frq,mn1);
%shading('interp');
[cmin,cmax]=caxis;
v=[cmin cmax];
title('cond1');

figure
pcolor(scl_time,scl_frq,mn2);
%shading('interp');
caxis(v);
title('cond2');

figure
pcolor(scl_time,scl_frq,t_thresh);
%shading('interp');
[cmin,cmax]=caxis;
v=[cmin cmax];
mxv=max(abs(v));
v=[-mxv mxv];
caxis(v);
title('stats cond1<>cond2 (t-value)');

