function pval = chi2test(J1,Var1,J2,Var2,Norient)
% chi2 test under null hypothesis of two populations have equal means
%
% --- syntax
% pval = chi2test(J1,Var1)        *** H0 : J1=0
% pval = chi2test(J1,Var1,J2,Var2)   *** H0 : J1=J2
% pval = chi2test(J1,Var1,[],[],2)
% 
% --- input
% J1, Var1 :
% J2, Var2 :
% 
% --- optional
% Norient : number of dipole orientation to be estimated
%
% "chi2cdf" is requried!! --> spm_Gcdf() is required !
%
% 2005-07-20 O.Y

if nargin < 2
    help chi2test;
    return;
end

if nargin < 5
    Norient = 1;
end

[Nvall,Nt]= size(J1);
Nv = Nvall/Norient; 

if nargin < 3 | isempty(J2) | isempty(Var2)
    fprintf('--- P-value of one population away from zeros using Chi2 statistics \n');
    J2 = zeros(Nvall,Nt);
    Var2 = zeros(Nvall,Nt);
else
    fprintf('--- P-value of two populations difference using Chi2 statistics \n');
end

%% test statistics (sum of squres)  H0: J1(t)=J2(t) forall t
switch Norient
    case 1,
        %fprintf('--- Number of Dipoles Orientations : %d \n', Norient);
        Jx = J1-J2;
        Varx = Var1+Var2; 
        tmp = Jx.^2./Varx;
        XX2 = sum(tmp,2); %% follows chi2 of freedom Nt
       % pval=chi2cdf(XX2, Nt);
        pval=spm_Gcdf(XX2,Nt/2,1/2);
    case 2,
        %fprintf('--- Number of Dipoles Orientations : %d \n', Norient);
        Jx = J1([1:Nv],:)-J2([1:Nv],:);
        Jy = J1([1:Nv]+Nv,:)-J2([1:Nv]+Nv,:);
        Varx = Var1([1:Nv])+Var2([1:Nv]);
        Vary = Var1([1:Nv]+Nv)+Var2([1:Nv]+Nv);  
        tmp = (Jx.^2./Varx)+ (Jy.^2./Vary);     
        XX2 = sum(tmp,2); %% follows chi2 of freedom 2*Nt
       % pval=chi2cdf(XX2, 2*Nt);
        pval=spm_Gcdf(XX2,2*Nt/2,1/2);
    case 3,
        %fprintf('--- Number of Dipoles Orientations : %d \n', Norient);
        Jx = J1([1:Nv],:)-J2([1:Nv],:);
        Jy = J1([1:Nv]+Nv,:)-J2([1:Nv]+Nv,:);
        Jz = J1([1:Nv]+2*Nv,:)-J2([1:Nv]+2*Nv,:);
        Varx = Var1([1:Nv])+Var2([1:Nv]);
        Vary = Var1([1:Nv]+Nv)+Var2([1:Nv]+Nv);  
        Varz = Var1([1:Nv]+2*Nv)+Var2([1:Nv]+2*Nv);
        tmp = (Jx.^2./Varx)+(Jy.^2./Vary)+(Jz.^2./Varz);     ;     
        XX2 = sum(tmp,2); %% follows chi2 of freedom 3*Nt
       % pval=chi2cdf(XX2, 3*Nt);
        pval=spm_Gcdf(XX2,3*Nt/2,1/2);
end