function [XYZmm]=vb_unsn(nXYZmm,sn)
% ---
% function [XYZmm]=vb_unsn(nXYZmm,sn)
%
% nXYZmm: mm coordinates in normalized volume [ 3 x nvoxels ]
% sn: filename or structure
%
% XYZmm: mm coordinates in original volume    [ 3 x nvoxels ]
%
% 2004/12/14 N.Goda
% 2006/02/23 Kawawaki, Dai
% 2008/09/11 Kawawaki, Dai
% 2010/05/12 Y. Takeda added spm8 support
% 2010/07/22 M. Sato simplified the switch logic, XYZvx is removed
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if isstr(sn), % backward compatibility
  sntmp=load(sn);
  sn=sntmp; 
end
if isfield(sn,'Dims')
  ver = 'spm99';
else
  switch lower(sn.VG(1).descrip)
   case 'minc file'
    ver = 'spm2';
   case 'nifti-1 image'
    ver = 'spm5';
   case 'grey matter tissue probability'
    ver = 'spm5';
   otherwise
    error('Cannot get SPM version.');
  end
end

switch ver
 case 'spm99'
  tmpl_dim=sn.Dims(1,:);    % [91,109,91]
  tmpl_nbasis=sn.Dims(2,:);
  tmpl_vox=sn.Dims(3,:);    % [2 2 2]
  tmpl_origin=sn.Dims(4,:); % [46,64,37]
  
  org_dim= sn.Dims(5,:);
  org_vox=sn.Dims(6,:);

  MF        = sn.MF;
  Transform = reshape(sn.Transform,tmpl_nbasis(1),...
		      tmpl_nbasis(2),tmpl_nbasis(3),3); % 2d->4d
  Affine    = sn.Affine;

 case {'spm2'}
  tmpl_dim=sn.VG(1).dim(1:3); % [91,109,91]
  tmpl_nbasis=size(sn.Tr);
  tmpl_vox=sqrt(sum(sn.VG(1).mat(1:3,1:3).^2));  % [2 2 2]
  tmpl_origin=sn.VG(1).mat\[0 0 0 1]'; %[46,64,37]
  tmpl_origin=tmpl_origin(1:3)';

  org_dim=sn.VF.dim(1:3);  % [191,256,256] etc
  org_vox=sqrt(sum(sn.VF.mat(1:3,1:3).^2));  % [2 2 2]

  MF        = sn.VF.mat;
  Transform = sn.Tr; % 4d
  Affine    = sn.Affine;
 case {'spm5'}
 	XYZmm = spm_get_orig_coord_spm5(nXYZmm', sn)';
 	return;
 otherwise
  error('There was a significant error. This program was aborted.');
end

flip_flag = 0;

switch ver
 case {'spm5'}
  [U,S,V] = svd(Affine(1:3,1:3));
  if det(U*V') > 0
    flip_flag = 1;
  end
end

% voxel coordinate in template
% (2mm^3 resolution, 91x109x91, origin [46,64,37])
% non-integer values are allowed 
x=nXYZmm(1,:)/tmpl_vox(1)+tmpl_origin(1);
y=nXYZmm(2,:)/tmpl_vox(2)+tmpl_origin(2);
z=nXYZmm(3,:)/tmpl_vox(3)+tmpl_origin(3);

basX = spm_dctmtx(tmpl_dim(1),tmpl_nbasis(1),x-1);
basY = spm_dctmtx(tmpl_dim(2),tmpl_nbasis(2),y-1);
basZ = spm_dctmtx(tmpl_dim(3),tmpl_nbasis(3),z-1);

Mult = MF*Affine;
XYZmm=zeros(size(nXYZmm));

trx0=reshape(Transform(:,:,:,1),tmpl_nbasis(1)*tmpl_nbasis(2),...
	     tmpl_nbasis(3));
try0=reshape(Transform(:,:,:,2),tmpl_nbasis(1)*tmpl_nbasis(2),...
	     tmpl_nbasis(3));
trz0=reshape(Transform(:,:,:,3),tmpl_nbasis(1)*tmpl_nbasis(2),...
	     tmpl_nbasis(3));

for j=1:length(z)
  tx0 = trx0*basZ(j,:)';
  ty0 = try0*basZ(j,:)';
  tz0 = trz0*basZ(j,:)';
  tx1 = reshape(tx0,tmpl_nbasis(1),tmpl_nbasis(2)) *basY(j,:)';
  ty1 = reshape(ty0,tmpl_nbasis(1),tmpl_nbasis(2)) *basY(j,:)';
  tz1 = reshape(tz0,tmpl_nbasis(1),tmpl_nbasis(2)) *basY(j,:)';
  tx2 = tx1' *basX(j,:)';
  ty2 = ty1' *basX(j,:)';
  tz2 = tz1' *basX(j,:)';

  X1 = x(j)+tx2;
  Y1 = y(j)+ty2;
  Z1 = z(j)+tz2;

  X2= Mult(1,1)*X1 + Mult(1,2)*Y1 + Mult(1,3)*Z1 + Mult(1,4);
  Y2= Mult(2,1)*X1 + Mult(2,2)*Y1 + Mult(2,3)*Z1 + Mult(2,4);
  Z2= Mult(3,1)*X1 + Mult(3,2)*Y1 + Mult(3,3)*Z1 + Mult(3,4);
  
  XYZmm(:,j)=[X2,Y2,Z2]';
  
  if flip_flag,
    XYZmm(1,j) = -XYZmm(1,j);
  end

end

return
