function [extra_info] = neuromag_load_extra_info(fiffile)
% load channel information from data-fiffile
% [USAGE]
%    [extra_info] = neuromag_load_extra_info(<fiffile>);
% [IN]
%    fiffile : neuromag data fiffile.
% [OUT]
%    extra_info : includes channel information and transform matrix
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

info = fiff_read_meas_info(fiffile);

%%%% --- load Channel info
% VBMEG channel type
NullChannel         = 0;
MagnetoMeter        = 1;
AxialGradioMeter    = 2;
PlannerGradioMeter  = 3;
%TriggerChannel      = -1;
EegChannel          = -2;
%EcgChannel          = -3;
EtcChannel          = -4;

ch_name   = info.ch_names';

% ch_name : STI 001 , EEG 001, MEG 2643
% ch_type : 0 (STI) , 1 (EEG)
% ch_id   :       1 ,       1,     2643

Nch = length(ch_name);
next = 0;
Channel_name    = [];
Channel_type    = [];
Channel_id      = [];
Channel_pos     = [];
Channel_active  = [];
gain            = [];

for n=1:Nch
	if strcmp(ch_name{n}(1:3),'STI')==1, 
		next = next + 1;
		Channel_name{next}    = ch_name{n};
		Channel_id(next)      = n;
		Channel_type(next)    = EtcChannel;
        Channel_pos           = [Channel_pos; nan, nan, nan];
		Channel_active(next)  = 1;
	end
		
   if strcmp(ch_name{n}(1:3),'EEG')==1, 
		next = next + 1;
		Channel_name{next}    = ch_name{n};
		Channel_id(next)      = n;
		Channel_type(next)    = EegChannel;
        if ~isempty(info.chs(n).eeg_loc)
            Channel_pos       = [Channel_pos; info.chs(n).eeg_loc(:,1)'];
        end
		Channel_active(next)  = 1;
	end
end

extra_info.Channel_name    = Channel_name';   
extra_info.Channel_type    = Channel_type(:);   
extra_info.Channel_id      = Channel_id(:);        
extra_info.Channel_pos     = Channel_pos;
extra_info.Channel_active  = Channel_active(:);    
extra_info.gain            = gain(:);

% MEGinfo.ExtraChannelInfo = extra_info;
%    gain            : []
%    Channel_active  : [48x1 double]
%    Channel_name    : {48x1 cell}
%    Channel_type    : [48x1 double]
%    Channel_id      : [48x1 double]
