function	job_trial_onset_nmag(proj_root,parm)
% get time index for each trial by checking status channel
% --- Usage
%    job_trial_onset_nmag(proj_root,parm)
% --- Input
%  parm.data_file : Data file name         [string]
%  parm.trig_file : Trial onset file name  [string]
%  parm.status_ch : status channel name    [string]
%  parm.trig_type = 'integer' or 'analog' or 'voice' or 'emg'
%  parm.slope = 'const_start' or 'const_end'    if trig_type = 'integer'
%               'low_to_high' or 'high_to_low'  if trig_type = 'analog'
%               No meaning                      if trig_type = 'voice','emg'
%  parm.condition : string describing condition [string or cell array]
%  parm.status_level : status level      [1 x Ncomdition]
%  parm.Pretrigger_ms : Pretrigger period   [msec]
%  parm.Posttrigger_ms: Posttrigger period  [msec]
% --- Save variables
% status : status signal
% status_val(m) = status value for m-th condition (m=1:Ncomdition)
% trig(n)       : Onset time index for n-th trial 
% cond_id(n)    : Condition ID for n-th trial 
% ix_trial(:,n) : Time index for n-th trial   [Tperiod x Ntrial]
%                 Tperiod : # of time sample in one trial
%                 Ntrial  : # of trials
% parm : parameter setting
% parm.fsamp : Sample Frequency [Hz]
%
% --- Optional parameter for EMG onset
% parm.t_event  : minimum distance from previous onset event [150 ms]
%                 distance from previous onset should be larger than t_event
% parm.p_val : P-value corresponding to the threshold for [EMG, smooth(EMG)] 
%	           [0.0001, 0.0005] or [0.0001, 0.001] 
%     cumulative histgram is used to determine threshold from P-value
%
% --- Usually following parameters need not be changed
% parm.hist_mode : histgram mode [1]
%                = 1: Estimate threshold by gamma distribution approximation
%                = 0: Estimate threshold by histgram
% parm.t_smooth : moving average window length               [25 ms]
% parm.t_slope  : slope estimation period near onset         [25 ms]
%                 if t_slope==0, zero cross point is not calculated
% parm.t_peak   : peak evaluation period                     [100 ms]
% peak_val : EMG value should exceed peak_val within 't_peak' after onset
%          = mean(peak value > threshold) if hist_mode = 1
%          = (max(y) * status_level)      if hist_mode = 0 or 2
% --- Condition for EMG onset
% 1. distance from previous onset should be larger than t_event
% 2. distance between EMG & smoothed EMG onset should be smaller than t_event
% 3. EMG value should exceed peak_val within t_peak after onset
% 4. zero cross point is estimated 
%    by linear fitting around smoothed EMG threshold point
%
%
% 2009-6-14  Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Original data file
fname = [proj_root filesep parm.data_file ];
ftrig = [proj_root filesep parm.trig_file ];

% Load info
info = vb_load_meg_info(fname);

% Sample Frequency [Hz]
parm.fsamp  = info.SampleFreq;

%if iscell(parm.status_ch),
%	status_ch = parm.status_ch;
%else
%	status_ch = {parm.status_ch};
%end

% Load status channel
%loadspec = [];
%loadspec.ChannelName = status_ch;
%status = load_meg_data(fname, loadspec);
load(fname,'MEGinfo','bexp_ext')

ch = strmatch(parm.status_ch{1}, MEGinfo.ExtraChannelInfo.Channel_name);
status = bexp_ext(ch,:);

[ix_trial, trig, cond_id, status_val,status] = ...
		vb_get_trial_time_index(status,parm);
% 		get_trial_time_index(status,parm);

if isempty(ix_trial), return; end;

% ix_trial(:,n) : Time index for n-th trial   [Tperiod x Ntrial]
tmin = min(ix_trial,[],1);
tmax = max(ix_trial,[],1);

% check time is inside the data
ix = find( (tmin > 0) & (tmax <= info.Nsample));

trig     = trig(ix);
ix_trial = ix_trial(:,ix);
cond_id  = cond_id(ix);

vb_fsave(ftrig,'ix_trial','trig','status','status_val','cond_id','parm');
