function [obj] = vb_mps_fileio_read(obj, mps_file)
% read mps file(.mps.mat).
% [USAGE]
%    [obj] = vb_mps_fileio_read(<obj>, <mps_file>)
% [IN]
%         obj : mps_fileio object
%    mps_file : mps filename
% [OUT]
%    obj : mps_fileio object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('mps_file', 'var') || isempty(mps_file)
    error('mps_file is a required parameter.');
end

s = load(mps_file);

%
% --- Parse file format and make objects
%

% make analyze_info object
obj.analyze_info = s.Analyzeinfo;

% make point_list object
NPoints = length(s.Base);
point_list = vb_mps_pointlist_new;

for k=1:NPoints
    point_list = vb_mps_pointlist_add_point(point_list,...
                                         s.Base{k}.name,...
                                         s.Base{k}.point);
end

obj.point_list = point_list;

