function [obj] = vb_display_factor_new(mtype_cell)
% construct display_factor object.
% display_factor object contains display_element object in its member
% and reffered by mri_point_select.
% [USAGE]
%    [obj] = vb_display_factor_new([mtype_cell]);
% [IN]
%   mtype_cell : marker type list {1xN}
%                marker type is the same as defined by plot function.
% [OUT]
%    obj : display_factor object.
%          is reffered by vb_mri_point_select and plot on mri slice.
%          set as AVWVIEW field.
% Sample :
%     % plot layer(defined by V, F) on mri slice
%     display_factor = vb_display_factor_new({'b-', 'r-', 'c-', 'm-'});
%     % add display element(V's coord should be analyze_right_mm)
%     display_factor = vb_display_factor_add_element(
%                               display_factor, ...
%                               vb_surf_element_new(name, coord, V, F, xx));
%     avw = avw_read_ras(analyze_file);
%     avw.display_factor = display_factor;
%     vb_mri_point_select(avw, '', 'init');
%
% Author: rhayashi
% Created: 2007-07-18
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('mtype_cell', 'var')
    mtype_cell = { 'y-' , 'r-' , 'c-' , 'g-' , 'w-', 'm-'};
end

%
% --- Main Procedure
%
obj = struct;
obj.mtype_cell = mtype_cell;
obj.element_cell = cell(0, 1);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
