function [obj, result] = vb_analyze_info_new(analyze_file)
% analyze_info constructor.
% [USAGE]
%    [obj, result] = vb_analyze_info_new(<analyze_file>);
% [IN]
%    analyze_file : analyze file(*.hdr)
% [OUT]
%       obj : analyze_info object
%    result : SUCCESS or FAILURE
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
obj = [];
result = FAILURE;

if exist(analyze_file, 'file') ~= 2
    return;
end

%
% --- Object Initalize
%

% Analyze header data
avw = avw_read_ras(analyze_file);

% Analyze Header info
obj.header = avw.hdr;

% File prefix
obj.file_prefix = avw.fileprefix;

% Dimension info
Vdim  = size(avw.img);
Vsize = avw.hdr.dime.pixdim(2:4);
%[Vdim, Vsize] = spm_hread(analyze_file);
obj.Vdim  = Vdim;
obj.Vsize = Vsize;

result = SUCCESS;
