function [avw] = avw_read_ras(fileprefix)
% avw_read - read Analyze/Nifti format data image to RAS
% 
% [avw] = avw_read_ras;
% [avw] = avw_read_ras(fileprefix);
% 
% This function calls load_nii_ras
% 
% fileprefix - a string, the filename without the .img extension.
%              A gui prompt appears if this argument is missing.
% 
% 
% Returned values:
% 
%  avw.hdr - a struct with image data parameters.
%  avw.img - a 3D matrix of image data (double precision).
%    For NIFTI
%  avw.fileprefix - NIFTI filename without extension.
%  avw.machine - machine string variable.
%  avw.filetype =
%     0 : Analyze .hdr/.img , (.hdr : 348 byte)
%     1 : NIFTI   .hdr/.img , (.hdr : 348 byte)
%         hdr.dime.vox_offset = 0;
%     2 : NIFTI   .nii      , (.nii : 348 byte hdr + 4 bite skip + image data)
%         hdr.dime.vox_offset = 352;
%
% Made by Masa-aki Sato 2008-02-17
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


if ~exist('fileprefix','var'),
  [pathname, fileprefix] = ...
     vb_file_select({'.nii', '.hdr'}, 'Analyze/Nifti .hdr/.nii file');
  if isempty(fileprefix)
    error('no file specified');
  else
    fileprefix = fullfile(pathname, fileprefix{1});
  end
end

avw = load_nii_ras(fileprefix);

return
