function make_bayes_meeg

sub = '030';

root = ['/home/cbi-data20/yusuke-f/Projects/VisualMotion/' sub '/'];

save_dir = 'test/';

day = 1;
cond = 4;

Dir  = ['data0' num2str(day)];

bp = vb_set_bayes_default_parameters;

% --- Input file (relative path from proj_root)
bp.brainfile = ['MEG/' Dir '/brain/' sub '.brain.mat'];
bp.areafile  = ['MEG/' Dir '/brain/' sub '.area.mat'];
bp.actfile   = ['MEG/' Dir '/brain/' sub '.act.mat'];

% --- Specify current area and fMRI activity
bp.area_key  = 'Cortex';
bp.act_key = '7_set1';
%bp.act_key = 'Uniform';
bp.prior_weight = 10e-5;

%bp.noise_estimation_model = 2; %update_sx = 0;
%bp.noise_estimation_model = 5; %update_sx = 0; %noise model = Identiby matrix

% --- Specify time window
time_signal=[0 1]; % Time window for analysis
time_noise=[-0.5 0]; % Time window for noise

meg_data_file=[root  'MEG/' Dir '/meg/epoch/i' sub '_' num2str(cond) '_Both.meg.mat'];
load(meg_data_file,'fileinfo')
time=fileinfo.time;

[~,from]=min(abs(time-time_signal(1)));
[~,to]=min(abs(time-time_signal(2)));
bp.twin_meg  = [from to]; % Time window for analysis
bp.Tperiod   = to-from+1; % Time period for current estimation
bp.Tnext     = to-from+1; % Time step for next period

[~,from]=min(abs(time-time_noise(1)));
[~,to]=min(abs(time-time_noise(2)));
bp.twin_noise  = [from to];
bp.twin_baseline = [from to];

% Reduce vertex
bp.reduce=0.5;
bp.reduce_global=0.5;
bp.patch_norm = ON;
%bp.trial_average=ON;
bp.Npre_train = 950;
bp.Ntrain = 100;

bp.bayesfile=[save_dir 'day' num2str(day) '_' num2str(cond) '.bayes.mat'];

%MEG
bp.megfile{1}=['MEG/' Dir  '/meg/epoch/i' sub '_' num2str(cond) '_Both.meg.mat'];
bp.basisfile_meg=['MEG/' Dir '/basis/' sub '_both_noPCA.basis.mat'];
bp.megfile_baseline=bp.megfile;

%EEG
bp.eegfile{1}=['EEG/' Dir '/eeg/epoch/i' sub '_' num2str(cond) '_Both.eeg.mat'];
bp.basisfile_eeg = ['EEG/' Dir '/basis_eeg/bn0.62_sk0.03_sn0.62.basis.mat'];
bp.eegfile_baseline=bp.eegfile;

bp = vb_set_noise_estimation_model(bp, root);

vb_job_vb_meeg(root, bp);

