function	[pname,fname,udir] = select_nii_ras_fname(logname, udir)
% Get RAS NIFTI file name by reading 'dcm2nii' logfile
%  and rename it by adding prefix 'RAS_'
%  and delete other orientation NIFTI files
% --- Output files: Three set of NIFTI files are saved by 'dcm2nii'
%  fname.hdr/img    : original image        : deleted
%  o+fname.hdr/img  : RAS orientation image : renamed
%  co+fname.hdr/img : cropped RAS image     : deleted
% ---
% [IN]
%    logname : dcm2nii log filename
%       udir : output directory
% [OUT]
%      pname : RAS filename with path
%      fname : Original NIfTI filename
% [NOTE]
%    If dcm2nii does not reorient, only original file will be returned.
%
% Masa-aki Sato 2010-01-10
%      rhayashi 2010-05-13 supported not reorienting case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

ext1 = '.hdr';
ext2 = '.img';

pname = ''; 
fname = '';
reorient = false;
cropped  = false;

fid = fopen(logname,'rt');	% text mode all platforms
while(1)
    line = fgetl(fid);
    % EOF check
    if ~ischar(line), break; end
    % Reorienting check
    ix = strmatch('Reorienting as', line);
    if ~isempty(ix), reorient = true; end
    % cropped check
    ix = strmatch('Cropping', line);
    if ~isempty(ix), cropped = true; end

    % Get Output filename : '->*.img' (ex. '->RH.img')
    if ~isempty(strfind(line, '->')) && ~isempty(strfind(line, '.img'))
        ix = strfind(line, '->');
        pname = line(ix(end)+2:end);
    end
end
fclose(fid);
if isempty(pname)
    warning('Cannot get subject name from dicom file.'); 
end

% Get .hdr file list
[fpath, flist] = vb_get_ext_fname(udir, ext1);
Nfile = length(flist);

% Base file name(= Remove '.img', ex.'RH')
fn0 = pname(1:end-4);

for n=1:Nfile
	switch	flist{n}, 
	case	fn0
        if reorient 
            % Delete original orientation
		    fprintf('Delete %s\n',[udir filesep fn0 ext1]);
		    delete([udir filesep fn0 ext1]);
		    delete([udir filesep fn0 ext2]);
        else
            % Return base filename
            pname = '';
		    fname = [fn0 ext1];
        end
	case	['co' fn0]
        if cropped
		    % Delete cropped image
		    fprintf('Delete %s\n',[udir filesep 'co' fn0 ext1]);
            delete([udir filesep 'co' fn0 ext1]);
            delete([udir filesep 'co' fn0 ext2]);
        end
	case	['o' fn0]
        if reorient
            % Rename RAS original orientation
            fprintf('Rename %s\n',[udir filesep 'o' fn0 ext1]);
            movefile([udir filesep 'o' fn0 ext1], [udir filesep 'RAS_' fn0 ext1], 'f');
            movefile([udir filesep 'o' fn0 ext2], [udir filesep 'RAS_' fn0 ext2], 'f');
            % Return RAS filename with path
  		    pname = [udir filesep 'RAS_' fn0 ext1];
            % Return base filename
		    fname = [fn0 ext1];
        end
	end
end
