function   [avw] = convert_nifti_to_ras(fname,fnout)
% Convert nifti file to RAS NIFTI file
% --- Usage
%   convert_nifti_to_ras(fname,fnout);
% --- Input
% fname : Input NIFTI file namw
% fnout : Output RAS NIFTI file name
%
% Made by Masa-aki Sato 2010-1-10
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


% Load NIFTI header & image
avw = load_nii_cbi(fname);

%  Check NIFTI format
if ~isfield(avw,'filetype') || avw.filetype == 0
	error('File is not Nifti-format');
end

% Change to RAS
avw = change_orient_ras(avw);

avw.filetype = 2;
%     1 : NIFTI   .hdr/.img , (.hdr : 348 byte)
%     2 : NIFTI   .nii      , (.nii : 348 byte hdr + 4 bite skip + image data)

if nargin==2 && ~isempty(fnout)
	% Save as NIFTI format
	save_nii_cbi(avw, fnout);
end
