function Delta = make_Delta(delaymat_ms, fs, cv, sd)
%
% - Input
% delaymat_ms : delay mat in dmrifile (assume conduction velocity 6m/s and 27ms self
% delay)
% fs : sampling rate (Hz)
% - Optional Input
% cv : conduction velocity (m/s)
% sd : self delay (ms)
%
% - Output
% Delta : unit with time point  
%
% 2015/10/13 O.Yamashita

sd0 = 27;
cv0 = 6;  

if nargin < 4
    sd = 27;
end
if nargin < 3
    cv = 6;
end

dt_ms = 1/fs * 1000; % ms 

if nargin < 3
    Delta = round(delaymat_ms / dt_ms);
else
    
    ix = find(delaymat_ms ~= 0); 
    distmat = zeros(size(delaymat_ms));
    distmat(ix) = (delaymat_ms(ix) - sd0) * cv0*1e-3; % m 
    
    delaymat_ms1 = distmat / cv * 1e3; % ms
    delaymat_ms1(ix) = delaymat_ms1(ix) + sd;
    Delta = round(delaymat_ms1 / dt_ms);  % 
    Delta = sparse(Delta);

end


    
    




