function [A,B,Sig,AT,BT]=lcd_trialfitls_holocalAR(Zact,Delta,p,lambda)
% MAR parameter estimate with l2 reguralization for higher order local AR
% model (holocalAR model)
%
% * higher order local AR model 
%  j(v,t) = sum_p a(v,p)*j(v,t-p) + sum_u b(v,u)*j(u,t-Delta(v,u)) + epsilon(t)
% 
% [Input] 
% Zact :  current waveforms [Nv Nt Ntrial]
% Delta : delay matrix (sparse) with unit of time points 
%         (i.e. all the elements must be integer representing dicrete time
%         points)
%   p    : AR order for local dynamics 
% 
% [Output]
%  A  : diagonal parts of MAR matrix (local dynamics)  [Nv,p]
%  B  : non-digonal parts of MAR matrix (distant interactions) [Nv Nv]
%
% 2017/09/23 OY

if nargin < 4
    lambda = 0;
end

[Nv,Nt,Ntr] = size(Zact);
Dmax = max(Delta(:));
Dmax = max([Dmax,p]);

Zsum=sum(sum(abs(Zact),3),2);
ixgood=find(Zsum ~= 0);
Zgood = Zact(ixgood,:,:);
Dgood = Delta(ixgood,ixgood);

B = zeros(Nv,Nv);
A = zeros(Nv,p);
BT = zeros(Nv,Nv);
AT = zeros(Nv,p);


for vv = 1 : length(ixgood)
    
    fprintf('process %04d ...\n',ixgood(vv));
    
    
    dvec = round(Dgood(vv,:));
    iv = setdiff(find(dvec ~= 0), vv); % other than self loop
    
    % define X,y 
    Ntt = Nt - Dmax;
    X = zeros(Ntt*Ntr, length(iv)+p);
    y = zeros(Ntt*Ntr,1);  
    for ntr = 1 : Ntr
        y((ntr-1)*Ntt+1:ntr*Ntt)=[Zgood(vv,Dmax+1:Nt,ntr)]';
        for aa = 1 : p
            X((ntr-1)*Ntt+1:ntr*Ntt,aa) = Zgood(vv,Dmax+1-aa:Nt-aa,ntr)';
        end
        nn = p+1;
        for uu = iv
            X((ntr-1)*Ntt+1:ntr*Ntt,nn) = Zgood(uu,Dmax+1-dvec(uu):Nt-dvec(uu),ntr)';
            nn = nn + 1;
        end
    end
    
   % least squares
   iXX = inv(X'*X + lambda*eye(length(iv)+p));
   Xy  = X'*y;
   
   w = iXX*Xy;
   e = y - X*w;
   sig = sum(e.^2)/(Ntt*Ntr - length(iv)-p);
   wT = w ./ sqrt(diag(iXX)) / sqrt(sig);

   if ixgood(vv) == 661, 
       display(vv)
   end

    % store reults
   A(ixgood(vv),:) = w(1:p);
   B(ixgood(vv),ixgood(iv)) = w(p+1:end);
   AT(ixgood(vv),:) = wT(1:p);
   BT(ixgood(vv),ixgood(iv)) = wT(p+1:end);
   Sig(ixgood(vv)) = sig;

    
    
    
    
    
end

 






