function [A,B,Lam,Sig]=lcd_fitl2reg2step_holocalAR(Zact,Delta,p,lambda)
% Two-step MAR parameter estimate with l2 reguralization for higher order local AR
% model (holocalAR model)
%
% * higher order local AR model 
%  j(v,t) = sum_p a(v,p)*j(v,t-p) + sum_u b(v,u)*j(u,t-Delta(v,u)) + epsilon(t)
% 
% [Input] 
% Zact :  current waveforms [Nv Nt]
% Delta : delay matrix (sparse) with unit of time points 
%         (i.e. all the elements must be integer representing dicrete time
%         points)
%   p    : AR order for local dynamics 
% lambda : a regularization parameter common to all the vertices
%          if set [], optimal lambda is computed for each vertex  
% 
% [Output]
%  A  : diagonal parts of MAR matrix (local dynamics)  [Nv,p]
%  B  : non-digonal parts of MAR matrix (distant interactions) [Nv Nv]
%
% 2016/02/01 O.Yamashita 


[Nv,Nt] = size(Zact);
Dmax = max(Delta(:));
Dmax = max([Dmax,p]);

B = zeros(Nv,Nv);
A = zeros(Nv,p);


for vv = 1 : Nv
    
    fprintf('process %04d ...\n',vv);
    
    y = [Zact(vv,Dmax+1:Nt)]';
    
    %
    % distant regressors
    %
    
    X = []; 
    dvec = round(Delta(vv,:));
    iv = setdiff(find(dvec ~= 0), vv); % other than self loop
    
    for uu = iv
        X = [X, Zact(uu,Dmax+1-dvec(uu):Nt-dvec(uu))'];
    end
    
    if ~isempty(X)
        [lam,sig,val,a] = wmn_solution(y,X,[],[],struct('flag_plot',0,'lambda',lambda));
        B(vv,iv) = a;
        e = y - X*a;  % residuals
    else
        e = y;
    end

    %
    % local regressors
    %
    X = [];
    for aa = 1 : p
    X = [X Zact(vv,Dmax-aa+1:Nt-aa)'];
    end
    [lam,sig,val,a] = wmn_solution(e,X,[],[],struct('flag_plot',0,'lambda',lambda));

    A(vv,:) = a;    

    
    Lam(vv) = lam;
    Sig(vv) = sig;
    
end


% figure,
% subplot(2,1,1)
% plot(A);
% subplot(2,1,2)
% plot(B');
% 






