function [XYZmni , IMGinfo] = trans_subj_mni_coord(V,parm)
% Transform coordinate of individual brain to the MNI starndard brain. 
% 
% -- Usage
% [XYZmni , IMGinfo] = trans_subj_mni_coord(V,parm)
% V : vertex coordinate [Npoint x 3] SPM-right-mm
% -- Input (Fields in 'parm' struct)
% parm.brainfile
% -- Output
% XYZmni  :  MNI coordinate  (unit:mm)       [Npoint * 3]
% IMGinfo.dd :  error distance between 'V' and points on the MNI brain
%
% 2014-11-10 Masa-aki Sato
% 2016-6-1 M Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Max radius to check minimum distance to corresponding point [mm]
if	isfield(parm,'Rlimit')
	Rlimit = parm.Rlimit;
else
	Rlimit = 4; 
end

% Max radius to search corresponding point [mm] in the 1st-step
if	isfield(parm,'Rmax')
	Rmax = parm.Rmax;
else
	Rmax = 2; 
end

% In the 1st-step, nearest point is searched within Rmax
% In the 2nd-step, nearest point is searched for all candidates
% This value determine, efficiency of search,
% but does not change the result

%%%
%%% Backward coordinate transformation 
%%%          from the template brain to a subject's brain  
%%% Template file is neurological format (right handed spm).

Npoint = size(V,1);

Vref = vb_load_cortex(parm.brainfile, 'subj');
Vmni = vb_load_cortex(parm.brainfile, 'MNI');

%%%
%%% Map MNI-coordinate to individual's cortical surface
%%%

fprintf('--- Mapping MNI-coordinate onto a subject-brain \n');

% Find nearest point in atlas for each vertex 'V'
%[indx, dd] = vb_find_nearest_point(pXYZmni, V*1000, Rmax, 100, 1, 1);
[indx, dd] = vb_find_nearest_point(Vref*1000, V, Rmax, 100, 1, 1);

% Map template-coordinate to subject cortex
% XYZmni : MNI-coordinate corresponding to V(:,1:3)
XYZmni = Vmni(indx,:)*1000;

% Number of points whose minimum distance is less than Rlimit
ix_match = find( dd <= Rlimit );
Nmatch   = length(ix_match);

IMGinfo.dd = dd;


fprintf('# of points = %d\n',Npoint)
fprintf('# of points ( d <= %3.0f mm ) = %d\n',Rlimit,Nmatch)
fprintf('# of points ( d >  %3.0f mm ) = %d\n',Rlimit,Npoint - Nmatch)
fprintf('dmax = %4.1f mm \n', max(dd))
%fprintf('[Xmin, Ymin, Zmin] = %6.1f %6.1f %6.1f\n',xmin)

