function	parm = set_pair_ch(posfile)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

parm = define_pair_channel;

p = load(posfile);

% Source channel
Nsource = length(parm.source);
parm.src_pos = zeros(Nsource,3);

for k=1:Nsource
    ix = strmatch(parm.source{k}, p.channel.name, 'exact');
    if isempty(ix)
        error('channel %s not found.\n', parm.source{k});
    end
    parm.src_pos(k,:) = p.channel.Xspm(ix, :);
end

% Detector channel
Ndetector = length(parm.detector);
parm.det_pos = zeros(Ndetector,3);

for k=1:Ndetector
    ix = strmatch(parm.detector{k}, p.channel.name, 'exact');
    if isempty(ix)
        error('channel %s not found.\n', parm.detector{k});
    end
    parm.det_pos(k,:) = p.channel.Xspm(ix, :);
end

return

if Npair~=size(det_pos,1)
	error('# of source and detector are different');
end

