function	h = plot_map_on_face(parm,facefile,ch_val,p)
% plot channel data value on face
%    h = plot_map_on_face(parm,facefile,ch_val,plot_parm)
% parm : pair channel structure
%        source: {1xNsrc cell}
%      detector: {1xNdet cell}
%    probe_pair: [Npairx2 double]
%       src_pos: [Nsrcx3 double]
%       det_pos: [Ndetx3 double]
% facefile 
% ch_val : channel data value [Npairx1 double]
% plot_parm : 
%	plot_parm.Msend = 'r.';
%	plot_parm.Mrecv = 'b.';
%	plot_parm.Msize = 20;
%	plot_parm.mode
%     = 0 : Smooth interpolation using 3 neighbor [default]
%     = 1 : Binary mode (No pactch reduction & nearest neighbor interpolation)
%
% 2015-7-1 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Reduced number of patch in face surface
Npatch=10000; 

if ~isfield(p,'mode'), p.mode=0; end

% Face surface
face = load(facefile);
V = face.Vspm;
F = face.F;

if p.mode == 0
	[F,V] = vb_reducepatch(F,V, Npatch); 
end

Nv = size(V,1);

% get_shortest_path from source to detector along head
[Xpath, Npath] = get_shortest_path(parm, facefile);

% source & detector channel pos
Npair = length(Npath);

src_pos = zeros(Npair,3);
det_pos = zeros(Npair,3);
ch_pos  = zeros(Npair,3);

for k=1:Npair
	Vpath = Xpath{k};
	
	src_pos(k,:) = Vpath(1,:);
	det_pos(k,:) = Vpath(end,:);
	
	% channel position: mid point
    N1 = max(fix( Npath(k)/2 ),1);
	ch_pos(k,:)  = Vpath(N1,:);
end

pos_mode = 1;
%  dd = sq_distance(X,Y, pos_mode=1)
%  X : (M x D) matrix 
%  Y : (N x D) matrix

% max-min distance between probe & channel pos
pos  = [src_pos; det_pos];
dd   = sq_distance(pos, ch_pos, pos_mode);
dmin = max(min(dd));

% Select vertex for channel plot
% DV(ch, id) = dist. of ch_pos(ch,:) & V(id,:)
DV = sq_distance(ch_pos, V, pos_mode);
dV = min(DV);

ix = find(dV < dmin);

% Select patch which include selected vertex points
Vin  = V(ix,:);
Fin  = vb_patch_select(ix,F,Nv);
% Convert to vertex index within selected subset 'ix'
Itrans = zeros(Nv,1);
Itrans(ix) = 1:length(ix);
Fin = Itrans(Fin);

% Outer area
iz = find(dV >= dmin);
Fout = vb_patch_select2(iz,F,Nv);

% --- Interpolation on face vertex using 3 neighbor channels 
%  W(n,1:3) : n-th interpolation coefficient
% --- Interpolation using 'W'
%  y(n,1:3) = Three data values corresponding to the distance dd(n,1:3)
%  y_interp(n) = sum( W(n,1:3) .* y(n,1:3) , 2)

% Find 3 neighbor channels for selected vertex Vin=V(ix,:)
DV = DV(:,ix);
[DV, Ich] = sort(DV);

switch	p.mode
case	0
	dn = sqrt(DV(1:3,:)');
	W  = vb_linear_interpolate3(dn);
	y  = sum( W .* ch_val(Ich(1:3,:)'), 2);
case	1
	y  = ch_val(Ich(1,:)');
end

y = double(y);

%
% --- Plot channel data on face
%
h = figure;

patch('Faces',Fin,'Vertices',Vin,'FaceColor','interp',...
    'FaceVertexCData',y,'EdgeColor','none',...
    'FaceLighting','none');
    
%material dull;

axis equal
hold on;

% Plot source & detector channel
plot3(src_pos(:,1), src_pos(:,2), src_pos(:,3), p.Msend,'MarkerSize',p.Msize);
plot3(det_pos(:,1), det_pos(:,2), det_pos(:,3), p.Mrecv,'MarkerSize',p.Msize);

%
% --- Plot outer surface 
vb_plot_surf(V,Fout);

camlight headlight;
