function	y = nonlinear_map(cmax,cmin,NX,mode)
%
% 2014-11-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

x  = (1:NX)/NX;

switch	mode
case	'gauss'
	% cmin =cmax*exp(-(0.5)^2/sx)
	% log(cmin/cmax) = -(0.5)^2/sx
	sx = (0.5)^2/log(cmax/cmin);
	xc = mean(x);
	y  = cmax*exp(-(x - xc).^2/sx);
case	'exp'
	% cmin =cmax*exp(-1/sx)
	sx = 1/log(cmax/cmin);
	y  = cmax*exp(-(1-x)/sx);
end

y = round(y);
y = max(y,cmin);
y = min(y,cmax);
