function C = cmap_gradation(clist,Nlevel,Nrep)
% Make gradation color map from color list
%  C = cmap_grad(clist,Nlevel,Nrep)
%    returns colormap matrix
%  cmap_grad(clist,Nlevel,Nrep)
%    set colormap
% --- Input
% clist : color value list [N x 3]
% Nlevel : number of levels in  one colormap
% Nrep   : number of repetition of basic colormap
% --- Output
% C : colormap matrix ([R G B] matix) : [NtotalLevel x 3]
%
% Masa-aki Sato 2014-10-30
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if size(clist,2) ~= 3, error('Color must be 3 vector'); end;

N = size(clist,1);

if N < 2, error('Color list must larger than 2 colors'); end;
if nargin<2, Nlevel=8; end;
if nargin<3, Nrep = 1; end;

C = [];

for n=1:N-1
	Ctmp = cmap_grad(clist(n,:),clist(n+1,:),Nlevel);
	if n > 1, Ctmp = Ctmp(2:end,:); end;
	C = [C; Ctmp];
end

C = repmat(C, [Nrep 1]);

if nargout==0
	colormap(C);
end
