function C = cmap_grad(chigh,clow,Nlevel)
% Make gradation color map from two color
%  C = cmap_grad(chigh,clow,Nlevel)
%    returns colormap matrix
%  cmap_grad(chigh,clow,Nlevel)
%    set colormap
% --- Input
% chigh : color corresponding to max value
% clow  : color corresponding to min value
% Nlevel : number of levels in colormap
% --- Output
% C : colormap matrix ([R G B] matix) : [Nlevel x 3]
%
% Masa-aki Sato 2008-8-1
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if length(chigh) ~= 3, error('Color must be 3 vector'); end;
if length(clow) ~= 3,  error('Color must be 3 vector'); end;

chigh = chigh(:)';
clow  = clow(:)';

if nargin<3, Nlevel=100; end;

step=1/(Nlevel-1);

% gradation
cgrad = [0:step:1]'; 

% difference of two color
cdif  = chigh - clow;

% colormap
C = vb_repadd( cgrad * cdif, clow);

if nargout==0
	colormap(C);
end
