function	cmap = cmap_cycle(base_color,bg_color,Ncycle,Nrepeat)
% make cyclic color map made by two colors
% cmap = cmap_cycle(color_name,Ncycle,Nrepeat)
% base_color : [N x 3] color map matrix
% bg_color   : [1 x 3] RGB color corresponding to background color
% Ncycle : cycle length 
%          if N < Ncycle, bg_color is added (Ncycle-N) times
%          if N >= Ncycle, base_color is trancated as [Ncycle x 3]
% Nrepeat : repetition number of cycle
% cmap : [(Ncycle*Nrepeat) x 3] color map matrix
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[N ,Nc]= size(base_color);

if Nc ~= 3, error('Color matrix must be N x 3'); end;

Nc = length(bg_color);

if Nc ~= 3, error('Color must be 1 x 3'); end;

if Ncycle > N,
	cmap = repmat(bg_color(:)', [Ncycle 1]);
	ix = 1:N;
	cmap(ix + (Ncycle-N), :) = base_color;
else
	cmap = base_color((N-Ncycle+1):N,:);
end

cmap = repmat(cmap,[Nrepeat 1]);
