function [c_streng_s, f_leng_s] = make_symmetry_matrix(c_streng, f_leng)
% Symmetrize connection strength matrix and fiber length matrix
%
% 2012/08/03 M.Fukushima
% 2012/10/02 M.Fukushima
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Nvact = size(c_streng,1);
c_streng_s = c_streng;
f_leng_s  = f_leng;

for ii = 1:Nvact
  for jj = (ii+1):Nvact
    if c_streng(ii,jj)||c_streng(jj,ii)
%       if c_streng(ii,jj)==0
%         c_streng_s(ii,jj) = c_streng(jj,ii);
%         f_leng_s(ii,jj)  = f_leng(jj,ii);
%       elseif c_streng(jj,ii)==0
%         c_streng_s(jj,ii) = c_streng(ii,jj);
%         f_leng_s(jj,ii)  = f_leng(ii,jj);
%       else
        mean_c_streng = 0.5*(c_streng(ii,jj) + c_streng(jj,ii));
        c_streng_s(ii,jj) = max(c_streng(ii,jj),c_streng(jj,ii));
        c_streng_s(jj,ii) = max(c_streng(ii,jj),c_streng(jj,ii));
        weighed_mean_f_leng = ...
          (c_streng(ii,jj)*f_leng(ii,jj) + c_streng(jj,ii)*f_leng(jj,ii))...
            /(2*mean_c_streng);
        f_leng_s(ii,jj) = weighed_mean_f_leng;
        f_leng_s(jj,ii) = weighed_mean_f_leng;
%       end
    end
  end
end


