function [status, result] = dmri_system(command, arg2)
% This command creates bash script file and execute.
% Use this script instead of system().
%  e.g. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~(nargin == 1 || nargin == 2)
    error('Please check function usage.');
end

%
% --- Main Procedure
%
dmri_setenv;

% Create base script including environment setup
sh_file = [tempname, '.sh'];
isok = dmri_script_file_create(sh_file);
if isok == false
    error('Failed to create temporary shellscript file: %s', sh_file);
end

% before command chech
% * Special(fslview is obsolete and renamed. but is very useful).
if strfind(command, 'fslview ')
    [s, r] = dmri_system('which fslview_deprecated');
    if s == 0 && ~isempty(r)
        command = strrep(command, 'fslview ', 'fslview_deprecated ');
    end
end

% Put command to the bottom of the file.
fid = fopen(sh_file, 'a');
if fid == -1
    error('Failed to open temporaryh shell script file: %s', sh_file);
end
fprintf(fid, '%s\n', command);
fclose(fid);

% Execute
if exist('arg2', 'var')
    [status, result] = system(sh_file, arg2);
else
    [status, result] = system(sh_file);
end
if status ~= 0 && ~isempty(result)
    ix = strfind(result, ':');
    result2 = result(ix(end-1):end);
    disp(['dmri_system(''', command ''');']);
    warning('dmri_system: Failed to execute command.\n reason: %s', result2);
end
