function log_info_list = dmri_fiber_log_info_get(work_dir)
% get fiber tracking logging directory list.
% (mainly used by fiber tracking program.)
%
% [Usage]
%     log_info_list = dmri_fiber_log_info_get(work_dir);
%
% [Input]
%    work_dir : working directory for fiber tracking.
%  (e.g. /home/DTI/processed/fibertrack/tpd887bb52_05ba_4b67_8303_64d366406529)
%
% [Output]
%   log_info_list : log directory list
%                   (k).log_file    : execution log file.
%                      .err_file    : error log file.
%                      .result_file : execution result file.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('work_dir', 'var')
    error('Please check function usage.');
end

%
% --- Main Procedure
%
log_info_list = [];

% list log directories
d = dir(fullfile(work_dir, 'log*'));
valid = find([d.isdir] ~= 0);
d = d(valid);

% extract log_file and error file one by one.
for k=1:length(d)

    log_dir = fullfile(work_dir, d(k).name);
    d2 = dir(fullfile(log_dir, '*.txt'));

    l = struct;
    l.log_file     = '';
    l.err_file     = '';
    l.result_file  = '';

    for j=1:length(d2)
        if ~isempty(strfind(d2(j).name, '.err.txt'))
            l.err_file = fullfile(log_dir, d2(j).name);
        elseif ~isempty(strfind(d2(j).name, 'result.txt'))
            l.result_file = fullfile(log_dir, d2(j).name);
        else
            l.log_file = fullfile(log_dir, d2(j).name);
        end
    end
    % combine
    log_info_list = [log_info_list; l];
end
