%
% --- Extract DTI 4D-NIfTI.gz, bvec, bval files
%
dti_dicom_dir   = '/home/cbi-data4/rhayashi/DWI/4';
output_dir      = '/home/cbi-data4/rhayashi/DWI/test_FA_image';
basename        = 'data'; 

dmri_4D_image_extract(dti_dicom_dir, output_dir, basename);
    % creates
    %  output_dir/basename.nii.gz
    %  output_dir/basename_bvec
    %  output_dir/basename_bval

%
% --- Motion Correction
%
data_4d_file = [output_dir, '/', basename, '.nii.gz'];
dmri_4D_image_correct(data_4d_file);
    % will put files into the same directory.
    %   (_ecc is added as a postfix.)
    %   data_ecc.nii.gz
    %   data_ecc_bvec
    %   data_ecc_bval

%
% --- Extract brain image and brain mask from 4D-NIfTI.gz
%
data_4d_ecc_file = [output_dir, '/', basename, '_ecc.nii.gz'];
threshold = 0.18;
brain_image_extract(data_4d_ecc_file, threshold);
    % will put files into the same directory.
    %   (_brain, _brain_mask is added as a postfix.)
    %   data_ecc_brain.nii.gz
    %   data_ecc_brain_mask.nii.gz

%
% --- Create FA image
%
brain_mask_file = [output_dir, '/data_ecc_brain_mask.nii.gz'];
bvec_file       = [output_dir, '/data_ecc_bvec'];
bval_file       = [output_dir, '/data_ecc_bval'];
basename        = 'data_ecc_FA';

dmri_FA_image_create(data_4d_ecc_file, ...
                    bval_file, bvec_file, ...
                    brain_mask_file, ...
                    output_dir, ...
                    basename);
    % will put files into the same directory.
    %    output_dir/basename.nii.gz
