function dmri_process_fiber_tracking_execute(p)
% Fiber tracking operation
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

%
% --- Fiber tracking and create Anatomical Matrix
%
parcel_dir    = fullfile(p.output_dir, p.parcels_dirname);

work_dir      = fullfile(p.output_dir, p.fiber_track_dirname);
mif_file      = fullfile(work_dir, p.fiber_mif_file);
mask_file     = fullfile(work_dir, p.fiber_mask_file);
anatmat_file  = fullfile(work_dir, p.anat_matrix_file);


% Fiber tracking hosts(Do not specify a host that runs this script.)
% Available hosts
% - cbi-node20-33
% - cbi-node01g-08g
% - cbi-node20g-23g
process_host  = p.hosts;

% The number of MATLAB processes which are used to process fiber tracking result files.
Nworker       = p.Nworker;

dmri_fiber_track_prob(mif_file, parcel_dir, mask_file, anatmat_file, process_host, Nworker);

