function dmri_process_T1_freesurfer(p)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


disp(mfilename);

%
% --- Previous check
%
if isfield(p, 'ref_fs_dir')
    if exist(p.ref_fs_dir, 'dir') == 7
        warning('FreeSurfer directory specified. skip creating.');
        return;
    elseif ~isempty(p.ref_fs_dir)
        error('Specified Freesurfer directory not found.');
    end
end

freesurfer_dir = fullfile(p.output_dir, p.fs_dirname, p.fs_sbj_name);
if exist(freesurfer_dir, 'dir') == 7
    warning('FreeSurfer directory already exist. skip creating.');
    return;
end

%
% --- Create cortex data using FreeSurfer 
%
if isfield(p, 'ref_mri_file') && ~isempty(p.ref_mri_file)
    mri_file = p.ref_mri_file;
else
    mri_file = fullfile(p.output_dir, p.t1_dirname, ['m', p.t1_file]);
end
if exist(mri_file, 'file') ~= 2
    error('Specified MRI file not found:%s', mri_file);
end

fs_root_dir      = fullfile(p.output_dir, p.fs_dirname);
subj_id          = p.fs_sbj_name;

% FreeSurfer
if exist(fs_root_dir, 'dir') ~= 7
    vb_mkdir(fs_root_dir);
end
vb_freesurfer_run(mri_file, fs_root_dir, subj_id);
