function dmri_process_T1_dicom_convert(p)
% convert T1 DICOM files to NIfTI(.nii)
% [Usage]
%    dmri_process_T1_dicom_convert(p);
% [Input]
%    p : dmri process parameter
%     .output_dir          : output directory.
%     .t1_dicom_dir        : T1-DICOM directory.
%     .t1_dicom_extension  : Extension of DICOM files.
%     .t1_dirname          : The data is put output_dir/t1_dirname
%     .t1_file             : T1-output filename.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

%
% --- Previous check
%
if isfield(p, 'ref_mri_file') && ~isempty(p.ref_mri_file)
    warning('T1-image create step is skipped because p.ref_mri_file is specified.');
    return;
end

%
% --- Dicom to NIfTI
%
if isfield(p, 't1_dicom_dir') && exist(p.t1_dicom_dir, 'dir')==7
    % data is specified, convert will start.
elseif isfield(p, 't1_dicom_dir') && isempty(p.t1_dicom_dir)
    error('T1-DICOM directory not speicifed.');
end
% Search *.dcm
d = dir(fullfile(p.t1_dicom_dir, ['*', p.t1_dicom_extension]));

% Input/output settings
input_dicom_file = fullfile(p.t1_dicom_dir, d(1).name); % set the one of files.
output_dir = fullfile(p.output_dir, p.t1_dirname);
if exist(output_dir, 'dir') ~= 7, mkdir(output_dir); end

% Convert
[t1_nifti_file] = convert_dicom_nifti(input_dicom_file, output_dir);

% Rename
t1_out_file = fullfile(p.output_dir, p.t1_dirname, p.t1_file);
movefile(t1_nifti_file, t1_out_file);

disp(sprintf('T1-file is created : %s', t1_out_file));
