function dmri_process_FA_image_clean(p)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

%
% --- Transform T1-struct brain and brain mask image into FA coordinate system.
%
from_file        = fullfile(p.output_dir, p.t1_dirname, [p.t1_brain_basename, '_brain_mask.nii.gz']);
brain_mask_file  = fullfile(p.output_dir, p.dwi_dirname, [p.t1_brain_basename, '_brain_mask_FA.nii.gz']);
to_ref_file      = fullfile(p.output_dir, p.dwi_dirname, [p.FA_coreg_basename, '.nii.gz']);
direction        = 'struct2fa_nointerp';
transinfo_dir    = fullfile(p.output_dir, p.transform_info_dirname);
dmri_image_transform(from_file, brain_mask_file, to_ref_file, ...
                            direction, transinfo_dir);

from_file     = fullfile(p.output_dir, p.t1_dirname,  [p.t1_brain_basename, '_brain.nii.gz']);
brain_file    = fullfile(p.output_dir, p.dwi_dirname, [p.t1_brain_basename, '_brain_FA.nii.gz']);
to_ref_file   = fullfile(p.output_dir, p.dwi_dirname, [p.FA_coreg_basename, '.nii.gz']);
direction     = 'struct2fa';
transinfo_dir = fullfile(p.output_dir, p.transform_info_dirname);
dmri_image_transform(from_file, brain_file, to_ref_file, ...
                            direction, transinfo_dir);


%
% --- Create clean FA image
%
dwi_file        = fullfile(p.output_dir, p.dwi_dirname, [p.dwi_basename, '_m.nii.gz']);
bval_file       = fullfile(p.output_dir, p.dwi_dirname, [p.dwi_basename, '_m.bval']);
bvec_file       = fullfile(p.output_dir, p.dwi_dirname, [p.dwi_basename, '_m.bvec']);
output_dir      = fullfile(p.output_dir, p.dwi_dirname);
output_name     = p.FA_basename;

dmri_FA_image_create(dwi_file, ...
                     bval_file, bvec_file, ...
                     brain_mask_file, ...
                     output_dir, ...
                     output_name);

% output_root/DWI/data_FA.nii.gz


% Check1. cleaned FA image by fslview
fa_file        = fullfile(p.output_dir, p.dwi_dirname, [p.FA_basename, '.nii.gz']);
fa_coreg_file  = fullfile(p.output_dir, p.dwi_dirname, [p.FA_coreg_basename, '.nii.gz']);
cmd = ['fslview ', fa_file, ' ', fa_coreg_file];
dmri_system(cmd);

% Check2. coregistration
cmd = ['fslview ', brain_file, ' ', fa_file];
dmri_system(cmd);

% Trouble shooting(.nii.gz should be converted into .nii using gunzip beforehand)
% dmri_system('erode data_dwi_m_brain_mask.nii - | erode - - | erode - - | mrmult data_FA_coreg.nii - data_FA.nii');
