function dmri_process_DWI_motion_correct(p)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

%
% --- Apply motion collection to Diffusion Weighted Image.
%
dwi_file = fullfile(p.output_dir, p.dwi_dirname, [p.dwi_basename, '.nii.gz']);

dmri_4D_image_correct(dwi_file);
% Create files (output basename = input basename + '_m')
%         output_dir/data_dwi_m.nii.gz
%         output_dir/data_dwi_m.bvec
%         output_dir/data_dwi_m.bval

% check by fslview
dwi_m_file = strrep(dwi_file, '.nii.gz', '_m.nii.gz');

cmd = ['fslview ' dwi_m_file];
dmri_system(cmd);
