function dmri_job_FA_preprocess(fa_parm)
% Create FA image.
%
% [Usage]
%     dmri_job_FA_preprocess(fa_parm);
%
% [Input]
%     fa_parm.dti_4d_image : DTI 4D-NIfTI.gz file(.nii.gz)
%                            with bvec file, bval file
%            .threshold    : fractional intensity threshold (0->1); 
%                            default=0.5; smaller values give larger brain 
%                            outline estimates.
%            .output_dir   : output directory
%            .basename     : basename of FA image.
%                            (e.g. 'data_FA)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin ~= 1
    error('Please check input argument.');
end
if ~isfield(fs_parm, 'dti_4d_image_file')
    error('dti_4d_image_file is a required field.');
end
if exist(fs_parm.dti_4d_image_file, 'file') ~= 2
    error('Specified dti_4d_image_file not found.');
end

%
% --- Extract brain image and brain mask from 4D-NIfTI.gz
%
data_4d_image_file = fs_parm.dti_4d_image_file;
if ~isfield(fs_parm, 'threshold')
    threshold = 0.5;
end
is_okay = false;
while(is_okay)
    brain_image_extract(data_4d_image_file, threshold);
        % will put files into the same directory.
        %   (_brain, _brain_mask is added as a postfix.)
        %   data_4d_image_file_brain.nii.gz
        %   data_4d_image_file_brain_mask.nii.gz


    % !! Quality Check !!
    % Is extracted skull stripped brain Okay?(Check the result.)
    command = ['fslview ' ...
                strrep(data_4d_image_file, '.nii.gz', '_brain.nii.gz'), ...
                ' ', data_4d_image_file];
    dmri_system(command);

    res = questdlg('Is the extracted skull stripped brain ok?', ...
                   'Quality check', ...
                   'Yes', 'No', 'No');

    % Input new threshold when the result is not good.
    if strcmpi(res, 'No')
        defaultanswer = {num2str(threshold)};
        new_threshold = ...
            inputdlg('Enter the threshold for skull strip', ...
                     'Input', 1, defaultanswer);
        if isempty(new_threshold)
           disp('Stopped processing.');
           return;
        else
           threshold = str2double(new_threshold{1});
        end
     else
        % exit loop
        is_okay = true;
     end
end

%
% --- Create FA image
%
brain_mask_file = [strrep(data_4d_image_file, '.nii.gz', '_brain_mask.nii.gz'];
bvec_file       = [strrep(data_4d_image_file, '.nii.gz', '_bvec'];
bval_file       = [strrep(data_4d_image_file, '.nii.gz', '_bval'];
basename        = 'data_ecc_FA';

dmri_FA_image_create(data_4d_image_file, ...
                     bval_file, bvec_file, ...
                     brain_mask_file, ...
                     output_dir, ...
                     basename);
    % will put files into the same directory.
    %    output_dir/basename.nii.gz
