function [parcel_to_list,parcel_from_list] = dmri_select_pairs_for_movie(Zact, Econ, Npairs, current_threshold)
% SELECT CONNECTIONS FOR DYNAMICS MOVIE
%
% current threshold -> select Npairs strongest effective connectivity
%
% [Input]
% Zact : current time series [Nv Nt]
% Econ : Effective connectivity matrix (non diagnal part of MAR matrix) [Nv Nv]
% Npairs : number of effective connectivity for display
% current_threshold : threshold for current vertex
%
% [Output]
% parcel_to_list, parcel_from_list : vertex indicies of pairs
%
% 2016/04/22 O.Yamashita
% 2022/09/21 Y.Takeda changed Npairs if the number of connectivity < Npairs
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 4
    current_threshold = 0.1;
end
if nargin < 3
    Npairs = 100;
end

Nvact = size(Zact,1);

% Current vertices over threshold (select larger amplitude vertices)
ix_act = find(sum(abs(Zact(:,:)) > current_threshold *max(abs(Zact(:))),2));

% Nparis strongest effective connectivity
tmp = Econ(ix_act, ix_act);
[sorttmp, jx] = sort(abs(tmp(:)), 1, 'descend');

% Change Npairs if the number of connectivity < Npairs
if sum(sorttmp>0) < Npairs
    Npairs = sum(sorttmp>0);
    disp(['The number of effective connectivity for display was changed to ' num2str(Npairs) '.'])
end

[I, J]=ind2sub(size(tmp), jx(1:Npairs));
parcel_to_list   = ix_act(I);
parcel_from_list = ix_act(J);
